/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.method.unihan;

import dev.architectury.platform.Platform;
import dev.architectury.utils.value.BooleanValue;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.search.method.CharacterUnpackingInputMethod;
import me.shedaniel.rei.api.client.search.method.InputMethod;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.search.method.unihan.UniHanInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.UniHanManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class PinyinInputMethod
extends UniHanInputMethod
implements CharacterUnpackingInputMethod {
    protected final Map<IntList, IntList> fuzzyMap = new LinkedHashMap<IntList, IntList>();
    protected final Int2ObjectMap<ToneEntry> toneMap;
    protected final Set<IntList> fuzzySet = new HashSet<IntList>();

    public PinyinInputMethod(UniHanManager manager) {
        super(manager);
        this.toneMap = new Int2ObjectOpenHashMap();
        this.addTone('\u0101', "a1");
        this.addTone('\u00e1', "a2");
        this.addTone('\u01ce', "a3");
        this.addTone('\u00e0', "a4");
        this.addTone('\u0113', "e1");
        this.addTone('\u00e9', "e2");
        this.addTone('\u011b', "e3");
        this.addTone('\u00e8', "e4");
        this.addTone('\u012b', "i1");
        this.addTone('\u00ed', "i2");
        this.addTone('\u01d0', "i3");
        this.addTone('\u00ec', "i4");
        this.addTone('\u014d', "o1");
        this.addTone('\u00f3', "o2");
        this.addTone('\u01d2', "o3");
        this.addTone('\u00f2', "o4");
        this.addTone('\u016b', "u1");
        this.addTone('\u00fa', "u2");
        this.addTone('\u01d4', "u3");
        this.addTone('\u00f9', "u4");
        this.addTone('\u01d6', "v1");
        this.addTone('\u01d8', "v2");
        this.addTone('\u01da', "v3");
        this.addTone('\u01dc', "v4");
        this.addFuzzy("z", "zh");
        this.addFuzzy("s", "sh");
        this.addFuzzy("c", "ch");
        this.addFuzzy("an", "ang");
        this.addFuzzy("en", "eng");
        this.addFuzzy("in", "ing");
        this.addFuzzy("ian", "iang");
        this.addFuzzy("uan", "uang");
        this.addFuzzy("n", "l");
        this.addFuzzy("r", "l");
        this.addFuzzy("h", "f");
        this.read();
    }

    private void addFuzzy(String original, String to) {
        this.fuzzyMap.put(IntList.of((int[])original.codePoints().toArray()), IntList.of((int[])to.codePoints().toArray()));
    }

    private void addTone(char c, String s) {
        this.toneMap.put((int)c, (Object)new ToneEntry(s.charAt(0), Character.digit(s.charAt(1), 10)));
    }

    protected void read() {
        Path path = Platform.getConfigFolder().resolve("roughlyenoughitems/pinyin.properties");
        this.fuzzySet.clear();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Properties properties = new Properties();
                try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                    properties.load(stream);
                }
                for (IntList key : this.fuzzyMap.keySet()) {
                    if (!properties.getOrDefault((Object)("Fuzzy:" + new String(key.toIntArray(), 0, key.size())), "false").equals("true")) continue;
                    this.fuzzySet.add(key);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        this.write();
    }

    protected void write() {
        Path path = Platform.getConfigFolder().resolve("roughlyenoughitems/pinyin.properties");
        Properties properties = new Properties();
        for (IntList key : this.fuzzyMap.keySet()) {
            if (!this.fuzzySet.contains(key)) continue;
            properties.put("Fuzzy_" + new String(key.toIntArray(), 0, key.size()), "true");
        }
        try (OutputStream stream = Files.newOutputStream(path, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            properties.store(stream, "Pinyin Options");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterable<IntList> expendFilter(String filter) {
        return Collections.singletonList(IntList.of((int[])filter.codePoints().toArray()));
    }

    @Override
    public List<CharacterUnpackingInputMethod.ExpendedChar> expendSourceChar(int codePoint) {
        List sequences = (List)this.dataMap.get(codePoint);
        if (sequences != null && !sequences.isEmpty()) {
            return sequences;
        }
        return List.of(new CharacterUnpackingInputMethod.ExpendedChar(List.of(IntList.of((int)codePoint))));
    }

    @Override
    protected String getFieldKey() {
        return "kMandarin";
    }

    @Override
    protected String getFieldDelimiter() {
        return " ";
    }

    @Override
    public List<InputMethod.Locale> getMatchingLocales() {
        return CollectionUtils.filterToList(InputMethod.getAllLocales(), locale -> locale.code().startsWith("zh_"));
    }

    @Override
    public Component getName() {
        return new TranslatableComponent("text.rei.input.methods.pinyin");
    }

    @Override
    public Component getDescription() {
        return new TranslatableComponent("text.rei.input.methods.pinyin.description");
    }

    @Override
    public List<FavoriteMenuEntry> getOptionsMenuEntries() {
        ArrayList<FavoriteMenuEntry> innerEntries = new ArrayList<FavoriteMenuEntry>();
        this.fuzzyMap.forEach((from, to) -> innerEntries.add(FavoriteMenuEntry.createToggle((Component)new TextComponent("%s -> %s".formatted(new String(from.toIntArray(), 0, from.size()), new String(to.toIntArray(), 0, to.size()))), new BooleanValue(){
            final /* synthetic */ IntList val$from;
            {
                this.val$from = intList;
            }

            public boolean getAsBoolean() {
                return PinyinInputMethod.this.fuzzySet.contains(this.val$from);
            }

            public void accept(boolean t) {
                if (t) {
                    PinyinInputMethod.this.fuzzySet.add(this.val$from);
                } else {
                    PinyinInputMethod.this.fuzzySet.remove(this.val$from);
                }
                PinyinInputMethod.this.write();
                PinyinInputMethod.this.dataMap.clear();
                PinyinInputMethod.this.load();
            }
        })));
        return List.of(FavoriteMenuEntry.createSubMenu((Component)new TranslatableComponent("text.rei.input.methods.pinyin.fuzzy.matching"), innerEntries));
    }

    @Override
    protected List<CharacterUnpackingInputMethod.ExpendedChar> asExpendedChars(String string) {
        List[] codepoints = new List[3];
        int skip = 2;
        int tone = -1;
        char[] chars = string.toCharArray();
        if (chars[0] == 's' && chars[1] == 'h') {
            codepoints[0] = this.expendInitials("sh");
        } else if (chars[0] == 'c' && chars[1] == 'h') {
            codepoints[0] = this.expendInitials("ch");
        } else if (chars[0] == 'z' && chars[1] == 'h') {
            codepoints[0] = this.expendInitials("zh");
        } else {
            skip = 1;
            ToneEntry toneEntry = (ToneEntry)this.toneMap.get((int)chars[0]);
            if (toneEntry == null) {
                codepoints[0] = this.expendInitials("" + chars[0]);
            } else {
                codepoints[0] = this.expendInitials("" + (char)toneEntry.codepoint());
                tone = toneEntry.tone();
            }
        }
        StringBuilder builder = new StringBuilder();
        for (int i = skip; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u00fc') {
                builder.append('v');
                continue;
            }
            ToneEntry toneEntry = (ToneEntry)this.toneMap.get((int)c);
            if (toneEntry == null) {
                builder.append(c);
                continue;
            }
            builder.append((char)toneEntry.codepoint());
            tone = toneEntry.tone();
        }
        int length = 2;
        if (builder.isEmpty()) {
            List<IntList>[] expendSingles = this.expendSingles(codepoints[0]);
            codepoints[0] = expendSingles[0];
            if (expendSingles.length > 1) {
                codepoints[1] = expendSingles[1];
            } else {
                length = 1;
            }
        } else {
            codepoints[1] = this.expendFinals(builder.toString());
        }
        if (tone != -1) {
            codepoints[++length - 1] = List.of(IntList.of((int)Character.forDigit(tone, 10)));
        }
        int combinations = 1;
        for (int i = 0; i < length; ++i) {
            combinations *= codepoints[i].size();
        }
        List[] results = new List[combinations];
        int[] current = new int[length];
        block2: for (int i = 0; i < combinations; ++i) {
            int k;
            results[i] = new ArrayList();
            for (k = 0; k < length; ++k) {
                results[i].add((IntList)codepoints[k].get(current[k]));
            }
            for (k = 0; k < length; ++k) {
                if (current[k] + 1 < codepoints[k].size()) {
                    int n = k;
                    current[n] = current[n] + 1;
                    continue block2;
                }
                current[k] = 0;
            }
        }
        return CollectionUtils.map(results, CharacterUnpackingInputMethod.ExpendedChar::new);
    }

    protected List<IntList>[] expendSingles(List<IntList> codepoint) {
        return new List[]{codepoint};
    }

    protected List<IntList> expendSimple(String string) {
        IntList codepoints = IntList.of((int[])string.codePoints().toArray());
        if (this.fuzzySet.contains(codepoints)) {
            return List.of(codepoints, this.fuzzyMap.get(codepoints));
        }
        return List.of(codepoints);
    }

    protected List<IntList> expendInitials(String string) {
        return this.expendSimple(string);
    }

    protected List<IntList> expendFinals(String string) {
        return this.expendSimple(string);
    }

    protected record ToneEntry(int codepoint, int tone) {
    }
}

